/* ********************************************************************************
# If you should have any comments, suggestions or improvements to these samples, 
# we welcome you to contact us at SampleCode@melissadata.com also please visit our 
# developers bulletin board at forum.melissadata.com.
# ******************************************************************************** */

/* ********************* LICENSE STRINGS **********************
#*     To unlock the full functionality of Address Object,     *
#* please call a sales representative at 1-800-MELISSA ext. 3  *
#*         (1-800-635-4772 x3) for a license string.           *
#*  Address Object will not function without a valid           *
#*      			  license string 			          	   *
#************************************************************* */

set pagesize 1000;

truncate table log;

declare
  so pls_integer;
  bno varchar2(1000);
  val varchar2(1000);
  ok integer;
begin

  insert into log values('starting');
  commit;

  so := mdStreetCreate();
  insert into log values('created mdStreet object');
  commit;

  ok := mdStreetSetLicenseString(so, 'SET_LICENSE_HERE');
  insert into log values('set license: ok=' || ok);
  commit;

  bno := mdStreetGetBuildNumber(so);
  insert into log values('build number= ' || bno);
  commit;

  ok := mdStreetInitialize(so, 'SET_PATH_HERE', 'SET_PATH_HERE', 'SET_PATH_HERE');
  insert into log values('init datafiles: error=' || ok);
  commit;

  /* test iteratitive interface to mdStreet */
  ok := mdStreetFindStreet(so, 'EM*', '92688', 0);
  while ok = 1
  loop
    insert into log values (
      mdStreetGetPrimaryRangeLow(so) || '-' || 
      mdStreetGetPrimaryRangeHigh(so) ||  ' ' ||
      mdStreetGetPreDirection(so) || ' ' ||
      mdStreetGetStreetName(so) || ' ' ||
      mdStreetGetSuffix(so) || ' ' ||
      mdStreetGetPostDirection(so) || ', ' ||
      mdStreetGetSuiteName(so) || ' ' ||
      mdStreetGetSuiteRangeLow(so) || '-' ||
      mdStreetGetSuiteRangeHigh(so));
    commit;

    ok := mdStreetFindStreetNext(so);
  end loop;

  mdStreetDestroy(so);
  insert into log values('destroyed mdStreet object');
  commit;

end;
.
run

select * from log;
/